**********************************************************************
**************DEBT AND CONSUMPTION - AGGREGATE EFFECT******************
************************DATE: 3 MAY 2018 ******************************
************************ AUTHOR: FIONA PRICE **************************
***********************************************************************
clear
set more off
use "C:\UnbalancedHH_analytical NEW.dta", replace
sort hhid0 wave

replace hequity=0 if hequity==. & hsvalue==-1
replace hdebt=0 if hdebt==. & hsmgowe==-1

mat Table8act = J(5,1,.)
mat rown Table8act = 2006 2007 2008 2009 2010
mat coln Table8act = Actual

mat Table8mpc = J(5,2,.)
mat rown Table8mpc = 2006 2007 2008 2009 2010
mat coln Table8mpc = Model Elasticity 

mat Table8ci5 = J(5,2,.)
mat rown Table8ci5 = 2006 2007 2008 2009 2010
mat coln Table8ci5 = Model Elasticity 

mat Table8ci95 = J(5,2,.)
mat rown Table8ci95 = 2006 2007 2008 2009 2010
mat coln Table8ci95 = Model Elasticity 

//identify changes in debt in between 2006 and 2010 for each househeold
gen changedebt=.
forval i=0/4{
local j=`i'+1
gen changedebt`i' = hdebt-L`i'.hdebt if wave==6+`i'
replace changedebt`i'=. if (hdebt==.) & wave==6+`i'
replace changedebt = changedebt`i' if wave==6+`i'
}

// mpc using model
xtreg d.consump d.inc L.d.hp1 L.d.hdebt i.agewmax i.educ kids hhadult married unemp nilf if L.hdebtt>0 & touse==1 & touse2==1 & touse3==1 & wave>=6 & wave<=10, fe cluster(hhid0) robust
gen mpc1 = _b[L.d.hdebt]
gen mpc15 = _b[L.d.hdebt] - invttail(e(df_r),0.025)*_se[L.d.hdebt]
gen mpc195 =_b[L.d.hdebt] + invttail(e(df_r),0.025)*_se[L.d.hdebt]

// mpc using elasticity
 xtreg consumpt inct L.hp1t i.agewmax i.educ kids hhadult married unemp nilf L.hdebtt if L.hdebtt>0 & touse==1 & touse2==1 & touse3==1  & wave>=6 & wave<=10,  fe cluster(hhid0) robust
gen mpc2 = (_b[L.hdebtt]*105)/100 //105 average ratio of o-o debt to consumption beween 2001 and 2017
gen mpc25 = ((_b[L.hdebtt] - invttail(e(df_r),0.025)*_se[L.hdebtt])*105)/100
gen mpc295 =((_b[L.hdebtt] + invttail(e(df_r),0.025)*_se[L.hdebtt])*105)/100

*** Finding estimated aggregate consumption based on mpcs and no change in debt ***
//estimates based on mpcs
local i=1
foreach x in mpc1 mpc2{
gen chconsump = (`x'*changedebt)
gen newconsump = consump - chconsump
bysort wave: egen sumconsumpn=sum(consump) if newconsump!=.
bysort wave: egen sumconsumpne=sum(newconsump)
tabstat sumconsumpne if wave>=6 & wave<=10,  by(wave) format(%15.0g) save
mat Table8mpc[1,`i']=r(Stat1)
mat Table8mpc[2,`i']=r(Stat2)
mat Table8mpc[3,`i']=r(Stat3)
mat Table8mpc[4,`i']=r(Stat4)
mat Table8mpc[5,`i']=r(Stat5)
drop chconsump newconsump sumconsumpn sumconsumpne
local i=`i'+1
}
//estimates based on 5% CI
local i=1
foreach x in mpc15 mpc25{
gen chconsump = (`x'*changedebt)
gen newconsump = consump - chconsump
bysort wave: egen sumconsumpn=sum(consump) if newconsump!=.
bysort wave: egen sumconsumpne=sum(newconsump)
tabstat sumconsumpne if wave>=6 & wave<=10,  by(wave) format(%15.0g) save
mat Table8ci5[1,`i']=r(Stat1)
mat Table8ci5[2,`i']=r(Stat2)
mat Table8ci5[3,`i']=r(Stat3)
mat Table8ci5[4,`i']=r(Stat4)
mat Table8ci5[5,`i']=r(Stat5)
drop chconsump newconsump sumconsumpn sumconsumpne
local i=`i'+1
}
//estimates based on 95% CI
local i=1
foreach x in mpc195 mpc295{
gen chconsump = (`x'*changedebt)
gen newconsump = consump - chconsump
bysort wave: egen sumconsumpn=sum(consump) if newconsump!=.
bysort wave: egen sumconsumpne=sum(newconsump)
tabstat sumconsumpne if wave>=6 & wave<=10,  by(wave) format(%15.0g) save
mat Table8ci95[1,`i']=r(Stat1)
mat Table8ci95[2,`i']=r(Stat2)
mat Table8ci95[3,`i']=r(Stat3)
mat Table8ci95[4,`i']=r(Stat4)
mat Table8ci95[5,`i']=r(Stat5)
drop chconsump newconsump sumconsumpn sumconsumpne
local i=`i'+1
}

// actual aggregate spending
gen chconsump = (mpc2*changedebt)
gen newconsump = consump - chconsump
bysort wave: egen sumconsumpn=sum(consump) if newconsump!=.
tabstat sumconsumpn if wave>=6 & wave<=10,  by(wave) format(%15.0g) save
mat Table8act[1,1]=r(Stat1)
mat Table8act[2,1]=r(Stat2)
mat Table8act[3,1]=r(Stat3)
mat Table8act[4,1]=r(Stat4)
mat Table8act[5,1]=r(Stat5)
sort hhid0 wave

matlist Table8act , format(%15.0g)
matlist Table8mpc , format(%15.0g)
matlist Table8ci5 , format(%15.0g)
matlist Table8ci95, format(%15.0g)
